<?php
	try {
		$scanner = 'local_scanner';

		if ( !empty($_POST) ){
			$xmlStr = "";
			if ( isset($_POST['Data']) ){
				$xmlStr .= $_POST['Data'];
			}
			$xmlObj = new SimpleXMLElement($xmlStr);
			if ($xmlObj->getName() == 'device_data' ){
				if ( $xmlObj->device_id == $scanner && $xmlObj->data->type == "ondata" ){
					header('Content-Type: text/xml; charset=UTF-8');
					echo getRequestXML($xmlObj->data->input);
				}
			}
		}
	} catch(Exception $e){
		;
	}

function getRequestXML($input)
{
	list ($giftNameForPrinter, $giftNameForDisplay) = getGiftName();
	$expireDate = "Expiration Date : ".date("m/d/Y", strtotime("+ 7 day"));
	$barcodeStr = getBarcodeString();
	$xml =<<<EOF
<device_data>
	<device_id>local_printer</device_id>
	<data>
		<type>print</type>
		<timeout>10000</timeout>
		<printdata>
			<epos-print xmlns="http://www.epson-pos.com/schemas/2011/03/epos-print">
				<text lang="en" dw="true" dh="false" reverse="true" ul="false" em="false"> Coupon &#10;</text>
				<feed line="3" />
				<text dw="true" dh="true" reverse="false">$giftNameForPrinter&#10;</text>
				<feed line="3" />
				<text dw="false" dh="false">$expireDate&#10;</text>
				<text font="font_b">$input</text>
				<feed line="2" />
				<barcode type="ean13" hri="below" height="40" font="font_b">$barcodeStr</barcode>
				<feed line="5" />
				<cut type="feed" />
			</epos-print>
		</printdata>
	</data>
</device_data>\x00
<device_data>
	<device_id>local_display</device_id>
	<data>
		<type>display</type>
		<timeout>10000</timeout>
		<displaydata>
			<epos-display xmlns="http://www.epson-pos.com/schemas/2012/09/epos-display">
				<reset/>
				<cursor type="none"/>
				<marquee format="place" repeat="1" uwait="100" rwait="2000">Thanks for coming!&#10;$giftNameForDisplay</marquee>
			</epos-display>
		</displaydata>
	</data>
</device_data>\x00
EOF;
	return $xml;
}

function getGiftName()
{
	$giftNamesForPrinter = array(
		"0" => "Drink &#10;10% OFF",
		"1" => "Drink &#10;15% OFF",
		"2" => "Lunch &#10;10% OFF",
		"3" => "Lunch &#10;15% OFF",
		"4" => "Bread &#10;10% OFF",
		"5" => "Bread &#10;15% OFF",
		"6" => "Snack &#10;10% OFF",
		"7" => "Snack &#10;15% OFF");
	$giftNamesForDisplay = array(
		"0" => "Drink 10% OFF",
		"1" => "Drink 15% OFF",
		"2" => "Lunch 10% OFF",
		"3" => "Lunch 15% OFF",
		"4" => "Bread 10% OFF",
		"5" => "Bread 15% OFF",
		"6" => "Snack 10% OFF",
		"7" => "Snack 15% OFF");
	$p = rand(0, 7);
	return array ($giftNamesForPrinter[$p], $giftNamesForDisplay[$p]);
}

function getBarcodeString()
{
	$b1 = sprintf('%06d', rand(100000, 999999));
	$b2 = sprintf('%06d', rand(     0, 999999));
	return $b1.$b2;
}
?>
