exports.SimpleSerial_Generic = SimpleSerial_Generic;

function SimpleSerial_Generic(clientConnection, deviceConnection) {
	this.DEVICE_TYPE = 'type_simple_serial';
	this.DEVICE_GROUP = 'group_serial';

	this.clientConnection = clientConnection;
	this.deviceConnection = deviceConnection;

	this.buf = '';

	this.callbackName = 'oncommandreply';

}

SimpleSerial_Generic.prototype = {
	sendcommand : function(data, sq) {

		var cmd = data.command;
		var cmdLength = cmd.length / 2;

		// Parsing the data sent by the client.
		var buf = new Buffer(cmdLength);
		for(var i=0; i<cmdLength; i++) {
			var byteData = parseInt(cmd.substring(i*2, i*2+2), 16);
			buf.writeUInt8(byteData, i);
		}
		// Sending to the serial device.
		this.deviceConnection.send(buf);

	},

	onDeviceData : function(value) {

		// Parsing the data generated by the serial device.
		for( var i=0; i<value.length; i++ ) {
			for( var j=0; j<value[i].byteData.length; j++ ) {
				var strData = value[i].byteData[j].toString(16);

				if(strData.length == 1) {
					strData = '0' + strData;
				}
				this.buf = this.buf + strData;
			}
		}

		// Sending to the client.
		var data = { "status" : "SUCCESS", "data" : this.buf};
		this.clientConnection.send(this.callbackName, data);

		this.buf = '';

	}
};
